<?php
// forward config updates to N8N if configured in .env/config.php
$config = require __DIR__ . '/config.php';
$body = file_get_contents('php://input');
$data = json_decode($body, true);
header('Content-Type: application/json');
if(empty($data)) { echo json_encode(['ok'=>false,'msg'=>'no data']); exit; }
if(!empty($config->N8N_URL) && !empty($config->N8N_API_KEY)) {
    $ch = curl_init(rtrim($config->N8N_URL, '/') . '/webhook/config-updated');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Authorization: Bearer ' . $config->N8N_API_KEY]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    echo json_encode(['ok'=>true,'n8n_code'=>$code,'n8n_resp'=>$resp]);
    exit;
}
echo json_encode(['ok'=>false,'msg'=>'n8n not configured']);