<?php
$config = require __DIR__ . '/config.php';
function supabase_request($endpoint, $method='GET', $body=null, $params=null) {
    global $config;
    $url = rtrim($config->SUPABASE_URL, '/') . '/rest/v1/' . ltrim($endpoint, '/');
    if ($params) $url .= '?' . http_build_query($params);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $headers = [
        'apikey: ' . $config->SUPABASE_SERVICE_ROLE_KEY,
        'Authorization: Bearer ' . $config->SUPABASE_SERVICE_ROLE_KEY,
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    if ($method !== 'GET') {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if ($body !== null) curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
    }
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($code >=200 && $code < 300) {
        $decoded = json_decode($resp, true);
        return $decoded === null ? $resp : $decoded;
    } else {
        return ['error' => 'HTTP ' . $code, 'body' => $resp];
    }
}
