<?php
$config = require __DIR__ . '/config.php';
function evolution_send_text($to_number, $message) {
    global $config;
    $url = rtrim($config->EVOLUTION_API_HOST, '/') . '/api/sendMessage';
    $payload = ['to' => $to_number, 'type' => 'text', 'text' => $message];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $config->EVOLUTION_API_KEY
    ]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['code' => $code, 'response' => $resp];
}
