<?php
$config = require __DIR__ . '/config.php';
function mercadopago_create_preference($amount, $external_reference) {
    global $config;
    $url = 'https://api.mercadopago.com/checkout/preferences';
    $payload = [
        'items' => [['title'=>'Entrega','quantity'=>1,'unit_price'=>floatval($amount)]],
        'external_reference'=>$external_reference
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json','Authorization: Bearer ' . $config->MERCADOPAGO_TOKEN]);
    $resp = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ['code'=>$code,'response'=>$resp];
}
function pagseguro_create_payment($amount,$reference){
    return ['code'=>200,'payment_url'=>'https://pagseguro.uol.com.br/checkout?ref='.urlencode($reference)];
}
